# Usage: awk -f jokesub.awk scijokes.txt > stat
# where scijokes.txt is the name of the science jokes file
# and stat the name of the outputfile
# count lines and sections in joke
# also counts subsections
BEGIN {
 i=0 ; j=0 ; k=0; starter=0;
 printf("%-36s %6s %5s %10s %12s\n",\
  "SECTION","JOKES","LINES","LINES/JOKE","CONTRIBUTORS");
 for(s=0;s<=75;s++) {printf("_");}; printf("\n");
 printf("%-36s","");
}
# version number
/^ver/ { if (!starter) {version=$0 ; starter=1}}
# next joke
/______________________/&&/M/ {imath++}
/______________________/&&/P/ {iphys++}
/______________________/&&/C/ {ichem++}
/______________________/&&/E/ {ieng++}
/______________________/&&/B/ {ibio++}
/______________________/&&/A/ {icomp++}
/______________________/ {i++ ;i0++}
# new section is characterized by number at beginning and all capital text.
  /^=[0-9]+\.[0-9]* / && !/[a-z]/ {
 totk=NR-tot;
 a=i?(totk/i):0 ;
 printf(" %6d %5d %10.4f %12d\n",i,totk,a,j);
 if (length($0)>36)  {printf("%s\n%36s",$0,"")}  else {printf("%-36s",$0)} ;
 tot=NR; k++; i=0; j=0;
}
# count contributors
/From:/||(/writes/&&/@/) {j++ ; j0++}
END { 
 totk=NR-tot;
 printf(" %6d %5d %10.4f %12d\n",i,totk,totk/i,j);
 for(s=0;s<=75;s++) {printf("_");}; printf("\n");
 printf("%-26s%10s %6d %5d %10.4f %12d\n",version,"TOTAL",i0,NR,NR/i0,j0); 
 printf("\n\n%16s %10s\n","Jokes including:","Number:")
 printf("%16s %10d\n","mathematics",imath)
 printf("%16s %10d\n","physics",iphys)
 printf("%16s %10d\n","chemistry",ichem)
 printf("%16s %10d\n","biology",ibio)
 printf("%16s %10d\n","engineering",ieng)
 printf("%16s %10d\n","computer science",icomp)
}
